package Back;

import java.io.*;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

public class Tree<T extends Serializable & Comparable<T>> implements Comparable<Tree<T>> {
    private Node<T> root;


    /**
     * konstruktor, priradi do hodnoty korena vrchol z parametra
     * ktory ak je null tak donho priradi prazdn konstruktor vrcholu
     * @param root koren stromu
     */
    public Tree(Node root) {
        if ( root == null ){
            this.root = new Node();
        } else {
            this.root = root;
        }
    }

    /**
     * otvori JSON so zadanym nazvom,
     * precita prve riadky pokial sa nedostane na
     * cast ktora patri korenu, na tu zavola konstruktor Ostatne.Node
     * ktoremu poda scanner
     * @param filename nazov suboru
     */
    public Tree(String filename)   {
        try {
            File file = new File(filename + ".json");
            Scanner s = new Scanner(file);
            s.nextLine();
            s.nextLine();
            root = new Node<T>(s);
        } catch (FileNotFoundException e){
            System.out.println("Wrong file name");
        }
    }


    public Tree()   {
        this.root = new Node();
    }



    /**
     * @return vracia koren stromu
     */
    public Node getRoot() {
        return root;
    }

    /**
     * nastavenie korenu stromu
     * @param root vrchol ktory sa pridaradi
     */
    public void setRoot(Node root) {
        this.root = root;
    }


    /**
     * @return vrati vylepseny vypis korena
     */
    @Override
    public String toString() {
        return root.print();
    }

    /**
     * @return zavola porovnanie korenov stromov, vysledok vrati
     */
    @Override
    public int compareTo(Tree<T> o) {
        return getRoot().compareTo(o.getRoot());
    }


    /**
     * @return zavola balance korena, vysledok vrati
     */
    public double getBalance(){
        return root.balance();
    }


    /**
     * @return vrati list listov, kde korene na spolocnej urovni su v spolocnom
     * liste, zachovava sa poradie kto je viac vpravo/vlavo
     */
    public List<ArrayList<Node<T>>> getAllLevels(){
        return root.getByLevels();
    }


    /**
     * na zaciatku prida do hlavneho listu koren ktory je na urovni 0,
     * na dalsiu uroven sa dostane tak ze pre kazdy vrchol v liste
     * prida do pomocneho jeho synov
     * po prejdeni vsetkych hlavny vycisti a prida donho pomocnym
     * opakuje pokial sa nedostane na pozadovanu uroven
     * @param level pozadovany level
     * @return vrati list s vrcholmi ktore su na pozadovanej urovni ( leveli )
     * zachovane poradie
     */
    public List<Node<T>> getLevel( int level ){
        int i = 0;

        ArrayList<Node<T>> s1 = new ArrayList<Node<T>>();
        s1.add(root);
        ArrayList<Node<T>> s2 = new ArrayList<Node<T>>();

        while ( i < level ) {
            for (Node<T> node : s1) {
                s2.addAll(node.getSons());
            }

            s1.clear();
            s1.addAll(s2);
            s2.clear();
            i++;
        }
        return s1;
    }

    /**
     * do korena pripoji vrchol druheho stromu
     * ak tato metoda vrati false - koren druheho sa nenachadza
     * v aktualnom, skusi to naopak - ak vrati true tak do
     * aktualneho korena priradi koren druheho
     * @param tree strom s ktorym spaja
     */
    public void join( Tree<T> tree ){   // animacia
        if ( !root.join(tree.root)){
            if ( tree.root.join(root)){
                root = tree.root;
            }
        }
    }

    /**
     * premiestni vrchol s hodnotou which do vrcholu s hodnotou where,
     * pomocou Ostatne.Node.move metody ktoru zavola na koren
     * @param where ciel premiestnovania
     * @param which premiestnovany vrchol
     */
    public void move( T which, T where ){
        root.move(which,where);
    }

    /**
     * odstrani vrchol s hodnotou node_v
     * @param node_v odrezavany vrchol
     */
    public void cut( T node_v){
        root.remove(node_v);
    }


    /**
     * do JSON suboru s danym menom zapise aktualny strom
     * @param filename meno suboru
     */
    public void save ( String filename){
        try {
            File create = new File(filename + ".json");
            create.createNewFile();

            FileWriter file = new FileWriter(filename + ".json");
            file.write(toJson());
            file.close();
            System.out.println("Saved to " + filename + ".json");

        } catch ( IOException e) {
            e.printStackTrace();
        }

    }

    /**
     * @return vrati string daneho stromu v JSON formate
     */
    private String toJson(){
        StringBuffer s = new StringBuffer();
        s.append( "{ \"Ostatne.Tree\" : { \n");
        s.append(" ".repeat(2) + "\"root\" : \n ");
        s.append(root.getJSon(2));
        s.append( " }\n}");
        return s.toString();
    }

    public static void main(String[] args) {

        Node<Double> n_12345d = new Node<>(1d,
                List.of(
                        new Node<>(2d, null),
                        new Node<>(3d, null),
                        new Node<>(4d, null),
                        new Node<>(5d, null))
        );


        Tree<Double> cisla = new Tree<>(n_12345d);

        cisla.save("cisla");
        Tree<Double> tree4 = new Tree<>("cisla");
        System.out.println(tree4);



        Node<String> n_jlmn = new Node<>("o",
                List.of(
                        new Node<>("j", null),
                        new Node<>("l", null),
                        new Node<>("m",  null),
                        new Node<>("n", null))
        );


        Node<String> n_dabkc = new Node<>("d",
                List.of(
                        new Node<>("a", null),
                        new Node<>("k", null),
                        new Node<>("b",  List.of(n_jlmn)),
                        new Node<>("c", null))
        );

        Node<String> n_habcdefg = new Node<>("h",
                List.of(
                        new Node<>("d",
                                List.of(
                                        new Node<>("a", null),
                                        new Node<>("b", null),

                                        new Node<>("c", null))
                        ),
                        new Node<>("e",
                                List.of(
                                        new Node<>("f", null),
                                        new Node<>("g", null),
                                        new Node<>("i", null))
                        )));


        Tree<String> tree1 = new Tree<>(n_habcdefg);
        Tree<String> tree2 = new Tree<>(n_dabkc);

        tree1.save("tree1");
        tree2.save("tree2");

        System.out.println("compare " + tree1.compareTo(tree2));

        tree2.join(tree1);
        tree2.save("tree3");

        Tree<String> tree3 = new Tree<>("tree3");
        System.out.println(tree3);

        tree3.move("d","e");
        System.out.println(tree3);

        tree3.cut("f");
        System.out.println(tree3);
/*





        Ostatne.Tree<String> tree3 = new Ostatne.Tree<>("tree1");

        System.out.println(tree1.compareTo(tree3));


        System.out.println(tree1.compareTo(tree2));

        System.out.println(tree2);

        tree2.join(tree1);


        tree2.move("d","e");
        tree2.cut("f");
        System.out.println(tree2);
        //System.out.println(tree2.toJson());

         */


        }
}
